/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import ibm.nways.nhm.file_server.FileInfo;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ImageObserver;
import java.util.Vector;

class FileListCanvas
extends Canvas
implements ImageObserver,
MouseListener,
ItemSelectable {
    private Image fileIcon;
    private Image folderIcon;
    private Image upFolderIcon;
    private String upFolderLabel;
    private Vector fileNameList;
    private Font labelFont;
    private FontMetrics labelMetrics;
    private int maxNameLength;
    private Image offScreenImage;
    private Dimension offScreenSize;
    private Graphics offScreenGraphics;
    private ItemListener itemListener;
    private ActionListener actionListener;
    private static final int NUM_ROWS = 5;
    private static final int COLUMN_GAP = 15;
    private int imageHeight;
    private int imageWidth;
    private int currentSelection = -1;
    private int newSelection = -1;
    private int rowHeight = 1;
    private int columnWidth = 1;
    private int textOffset;

    public FileListCanvas(Image image, Image image2, Image image3, String string) {
        this.fileIcon = image;
        this.folderIcon = image2;
        this.upFolderIcon = image3;
        this.upFolderLabel = string;
        this.imageHeight = this.fileIcon.getHeight(this);
        this.imageWidth = this.fileIcon.getWidth(this);
        this.addMouseListener(this);
    }

    public void setFileNames(Vector vector) {
        this.labelFont = new Font("Times", 1, 10);
        this.labelMetrics = this.getFontMetrics(this.labelFont);
        this.setFont(this.labelFont);
        this.fileNameList = vector;
        if (this.fileNameList != null) {
            int n = 0;
            while (n < this.fileNameList.size()) {
                this.maxNameLength = Math.max(this.maxNameLength, this.labelMetrics.stringWidth(((FileInfo)this.fileNameList.elementAt(n)).getName()));
                ++n;
            }
        }
        this.currentSelection = -1;
        this.newSelection = -1;
        this.offScreenImage = null;
        this.repaint();
    }

    public void newFolder(String string) {
        this.fileNameList.addElement(new FileInfo(string, true));
        this.maxNameLength = Math.max(this.maxNameLength, string.length());
        this.newSelection = this.fileNameList.size() - 1;
        this.processItemEvent();
        this.repaint();
    }

    public synchronized void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.offScreenImage == null || dimension.width != this.offScreenSize.width || dimension.height != this.offScreenSize.height) {
            this.offScreenImage = this.createImage(dimension.width, dimension.height);
            this.offScreenSize = dimension;
            this.offScreenGraphics = this.offScreenImage.getGraphics();
            this.myPaint(this.offScreenGraphics);
        } else if (this.newSelection != this.currentSelection) {
            this.changeSelection(this.offScreenGraphics);
        }
        graphics.drawImage(this.offScreenImage, 0, 0, null);
    }

    protected void changeSelection(Graphics graphics) {
        int n;
        int n2;
        if (this.currentSelection != -1) {
            n2 = this.currentSelection / 5;
            n = this.currentSelection % 5;
            graphics.setColor(this.getBackground());
            graphics.fillRect(n2 * this.columnWidth + this.imageWidth + 5, n * this.rowHeight + 2, this.columnWidth - this.imageWidth - 5, this.rowHeight - 4);
            this.drawNotSelected(graphics, (FileInfo)this.fileNameList.elementAt(this.currentSelection), n2, n);
        }
        if (this.newSelection != -1) {
            n2 = this.newSelection / 5;
            n = this.newSelection % 5;
            this.drawSelected(graphics, (FileInfo)this.fileNameList.elementAt(this.newSelection), n2, n);
        }
        this.currentSelection = this.newSelection;
    }

    protected void myPaint(Graphics graphics) {
        if (this.fileNameList != null && !this.fileNameList.isEmpty()) {
            int n = this.fileNameList.size();
            int n2 = n / 5;
            if (n % 5 > 0) {
                ++n2;
            }
            this.rowHeight = Math.max(this.imageHeight, this.labelMetrics.getHeight());
            this.columnWidth = this.maxNameLength + this.imageWidth + 15;
            this.textOffset = this.rowHeight / 3;
            this.setSize(n2 * this.columnWidth, 5 * this.rowHeight);
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < n) {
                if (n5 == this.currentSelection) {
                    this.drawSelected(graphics, (FileInfo)this.fileNameList.elementAt(n5), n3, n4);
                } else {
                    this.drawNotSelected(graphics, (FileInfo)this.fileNameList.elementAt(n5), n3, n4);
                }
                if (++n4 == 5) {
                    n4 = 0;
                    ++n3;
                }
                ++n5;
            }
        }
    }

    protected void drawSelected(Graphics graphics, FileInfo fileInfo, int n, int n2) {
        Image image = fileInfo.isDirectory() ? (this.upFolderLabel.equals(fileInfo.getName()) ? this.upFolderIcon : this.folderIcon) : this.fileIcon;
        graphics.drawImage(image, n * this.columnWidth, n2 * this.rowHeight, Color.red, this);
        graphics.setColor(this.getForeground());
        graphics.fillRect(n * this.columnWidth + this.imageWidth + 5, n2 * this.rowHeight + 2, this.columnWidth - this.imageWidth - 5, this.rowHeight - 4);
        graphics.setColor(this.getBackground());
        graphics.drawString(fileInfo.getName(), n * this.columnWidth + this.imageWidth + 5, (n2 + 1) * this.rowHeight - this.textOffset);
    }

    protected void drawNotSelected(Graphics graphics, FileInfo fileInfo, int n, int n2) {
        Image image = fileInfo.isDirectory() ? (this.upFolderLabel.equals(fileInfo.getName()) ? this.upFolderIcon : this.folderIcon) : this.fileIcon;
        graphics.setColor(this.getForeground());
        graphics.drawImage(image, n * this.columnWidth, n2 * this.rowHeight, this);
        graphics.drawString(fileInfo.getName(), n * this.columnWidth + this.imageWidth + 5, (n2 + 1) * this.rowHeight - this.textOffset);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return false;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX() / this.columnWidth;
        int n3 = n2 * 5 + (n = mouseEvent.getY() / this.rowHeight);
        if (n3 < this.fileNameList.size()) {
            if (n3 != this.currentSelection) {
                this.newSelection = n3;
                this.processItemEvent();
                this.repaint();
                return;
            }
        } else {
            this.newSelection = -1;
            this.processItemEvent();
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        int n2;
        int n3;
        if (mouseEvent.getClickCount() == 2 && (n3 = (n2 = mouseEvent.getX() / this.columnWidth) * 5 + (n = mouseEvent.getY() / this.rowHeight)) < this.fileNameList.size() && this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, null));
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public Object[] getSelectedObjects() {
        FileInfo[] fileInfoArray = null;
        if (this.currentSelection >= 0) {
            fileInfoArray = new FileInfo[]{this.fileNameList.elementAt(this.currentSelection)};
        }
        return fileInfoArray;
    }

    protected void processItemEvent() {
        if (this.itemListener != null) {
            if (this.currentSelection >= 0) {
                this.itemListener.itemStateChanged(new ItemEvent(this, 701, ((FileInfo)this.fileNameList.elementAt(this.currentSelection)).getName(), 2));
            }
            if (this.newSelection >= 0) {
                this.itemListener.itemStateChanged(new ItemEvent(this, 701, ((FileInfo)this.fileNameList.elementAt(this.newSelection)).getName(), 1));
            }
        }
    }
}

